unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComDrv, SMSDrv32;

type
  TfrmDemo = class(TForm)
    smsd: TSMSDriver;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    dor: TCheckBox;
    df: TCheckBox;
    edCOM: TEdit;
    edBaud: TEdit;
    edInit1: TEdit;
    edInit2: TEdit;
    edInit3: TEdit;
    edPD: TEdit;
    edRT: TEdit;
    edStor: TEdit;
    edSMSC: TEdit;
    edPIN: TEdit;
    btnSet: TButton;
    btnConnect: TButton;
    btnDisconnect: TButton;
    btnReset: TButton;
    mError: TMemo;
    edPhone: TEdit;
    mMess: TMemo;
    Label11: TLabel;
    Button1: TButton;
    Label12: TLabel;
    tm: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure btnSetClick(Sender: TObject);
    procedure btnConnectClick(Sender: TObject);
    procedure btnDisconnectClick(Sender: TObject);
    procedure btnResetClick(Sender: TObject);
    procedure smsdDeleteSMS(Sender: TObject; Reference: String);
    procedure smsdNotifySMS(Sender: TObject; Mem, Reference: String);
    procedure smsdReceiveSMS(Sender: TObject; Header, MessageBody: String);
    procedure smsdSentSMS(Sender: TObject; Reference: String);
    procedure smsdSMSError(Sender: TObject; ErrorId: Integer;
      ErrorMessage: String);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmDemo: TfrmDemo;

implementation

{$R *.DFM}

procedure TfrmDemo.FormCreate(Sender: TObject);
begin
  with smsd do
  begin
    edCOM.Text:=Port;
    edBaud.Text:=IntToStr(Baud);
    edInit1.Text:=InitString1;
    edInit2.Text:=InitString2;
    edInit3.Text:=InitString3;
    edPD.Text:=IntToStr(smsd.PollingDelay);
    edRT.Text:=IntToStr(smsd.ReadTimeout);
    edStor.Text:=StorageString;
    edSMSC.Text:=SMSCenter;
    edPIN.Text:=PIN;
    dor.Checked:=DeleteOnRead;
    df.Checked:=DirectForward;
    tm.Checked:=TextMode;
  end;
end;

procedure TfrmDemo.btnSetClick(Sender: TObject);
begin
  with smsd do
  begin
    Port:=edCOM.Text;
    Baud:=StrToInt(edBaud.Text);
    InitString1:=edInit1.Text;
    InitString2:=edInit2.Text;
    InitString3:=edInit3.Text;
    smsd.PollingDelay:=StrToInt(edPD.Text);
    smsd.ReadTimeout:=StrToInt(edRT.Text);
    StorageString:=edStor.Text;
    SMSCenter:=edSMSC.Text;
    PIN:=edPIN.Text;
    DeleteOnRead:=dor.Checked;
    DirectForward:=df.Checked;
    TextMode:=tm.Checked;
    if Connected then Reset;
  end;
end;

procedure TfrmDemo.smsdDeleteSMS(Sender: TObject; Reference: String);
begin
  MessageDlg('Message Ref: '+Reference+' was succesfully deleted.',mtInformation,[mbOK],0);
end;

procedure TfrmDemo.smsdNotifySMS(Sender: TObject; Mem, Reference: String);
begin
  if MessageDlg('New message received. Do you want to read it now?',mtConfirmation,[mbYes,mbNo],0) = mrYes then
  begin
    MessageDlg(smsd.ReadSMS(Reference),mtInformation,[mbOK],0);
    if not smsd.DeleteOnRead then
      if MessageDlg('Do you want to delete it?',mtConfirmation,[mbYes,mbNo],0) = mrYes then
        smsd.DeleteSMS(Reference);
  end;
end;

procedure TfrmDemo.smsdReceiveSMS(Sender: TObject; Header,
  MessageBody: String);
begin
  MessageDlg('New message received.'+#13#10+
    Header+#13#10+MessageBody,mtInformation,[mbOK],0);
end;

procedure TfrmDemo.smsdSentSMS(Sender: TObject; Reference: String);
begin
  MessageDlg('Message Ref: '+Reference+' was succesfully sent.',mtInformation,[mbOk],0);
end;

procedure TfrmDemo.smsdSMSError(Sender: TObject; ErrorId: Integer;
  ErrorMessage: String);
begin
  mError.Lines.Add(IntToStr(ErrorId)+' - '+ErrorMessage);
end;

procedure TfrmDemo.btnConnectClick(Sender: TObject);
begin
  smsd.Connect;
end;

procedure TfrmDemo.btnDisconnectClick(Sender: TObject);
begin
  smsd.Disconnect;
end;

procedure TfrmDemo.btnResetClick(Sender: TObject);
begin
  smsd.Reset;
end;

procedure TfrmDemo.Button1Click(Sender: TObject);
begin
  smsd.SendSMS(edPhone.Text,mMess.Lines.Text);
end;

end.
